## Ejemplo con Glut
import OpenGL
OpenGL.ERROR_CHECKING = False
from OpenGL.GL import *
from OpenGL.GLUT import *

def init() :
    glShadeModel(GL_SMOOTH)
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glClearDepth(1.0)
    glDisable(GL_DEPTH_TEST)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)

def reshape((width, height)):
    if height == 0:
        height = 1
    glViewport(0, 0, width, height)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

def display():
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glColor3f(1.0, 0.0, 0.0)
    glBegin(GL_TRIANGLES)
    glVertex3f(0.0, 0.0, 0.0)
    glVertex3f(0.5, 0.5, 0.0)
    glVertex3f(0.5, 0.0, 0.0)
    glEnd()
    #esta instruccion permite mostrar el contenido actual
    glutSwapBuffers()

def idle() :
    glutPostRedisplay();

def main() :
    ##Crear e inicializar la pantalla
    glutInitDisplayMode(GLUT_RGB|GLUT_DEPTH|GLUT_DOUBLE)
    glutInitWindowSize(640, 480)
    glutInit()
    glutCreateWindow("Ejemplo OpenGL-GLUT")
    ##Pinta en la pantalla
    glutDisplayFunc(display)
    ##Que hacer cuando.. no hay nada que hacer!
    glutIdleFunc(idle)
    ##Limpiar inicialmente la pantalla
    init();
    glutMainLoop()
    return 0

##me permite usar esto como modulo
if __name__ == "__main__" :
    main ()
